﻿/*	VERSION:	1.8

USAGE:
	#include "functions/nestedEval.as"
	myObj.var1 = 1.1;
	string = "[Math.ceil([myObj.var1])]";
	result = nestedEval( string );		// 2

DESCRIPTION:	
	This evaluates variable paths contained in [], and outputs the resulting string.
		"myvar = [myVar]"  ->  "myvar = value"
	This also call functions contained within []
		"[Math.ciel(1.1)]"  ->  "2"
	
	This accepts both full paths, or relative paths.
	Relative paths are assumed to be located within the specified 'defaultContainer"
	If no "defaultContainer" is specified, relative paths are assumed to be local variables within "this"
	"defaultContainer" is an optional parameter.
	Full paths are automatically detected.
*/
#include "evalPath.as"
nestedEval = function( inputPath, defaultContainer )
{
	var inputPath = String(inputPath);
	var output = "";
	// resolve defaultContainer
	if(!defaultContainer)
		var defaultContainer = this;
	// divide path into array
	var path_array = inputPath.split("[");
	// loop backwards through array  (skip 1st element)
	var output = "";
	for(var i=path_array.length-1; i>0; i--)
	{
		var thisPart = path_array[i] +output;
		// find 1st ]
		var endAt = thisPart.indexOf("]");
		// append remaining string to beginning
		output = thisPart.substr(endAt+1);
		// eval the contents before the ]
		var innerPart = thisPart.substr(0,endAt);
		var result = evalPath( innerPart, defaultContainer );
		// append result to beginning
		output = result + output;
	}// for: each eval group  (moving backwards)
	// append 1st element to beginning
	output = path_array[0] +output;
	// return resulting string
	return output;
}// nestedEval()